// routes/public-portal-templates.cjs (create this file if missing)
const express = require('express');
const router = express.Router();
const PublicPortalTemplate = require('../models/PublicPortalTemplate.cjs');
const { auth } = require('../middleware/auth.cjs');

router.get('/', auth, async (req, res) => {
  try {
    const templates = await PublicPortalTemplate.find({
      $or: [
        { company: req.user.company._id },
        { isBuiltIn: true }  // include the default seeded template
      ]
    })
      .select('name description isDefault isBuiltIn')
      .sort({ isDefault: -1, name: 1 })
      .lean();

    res.json(templates);
  } catch (err) {
    console.error('Error fetching public portal templates:', err);
    res.status(500).json({ message: 'Erro interno ao listar templates' });
  }
});

module.exports = router;