const mongoose = require('mongoose');

const serviceSchema = new mongoose.Schema({
  company: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Company',
    required: true
  },
  name: { type: String, required: true, trim: true },
  description: { type: String },
  unit: { 
    type: String, 
    enum: ['unit', 'box', 'set', 'monthly', 'weekly', 'daily', 'yearly'],
    default: 'unit'
  },
  basePrice: { type: Number, required: true, min: 0 },
  targetAudience: { type: String }, // e.g., "Corporate", "Individual"
  allowedInstallments: { type: Number, default: 3 }, // Free installments
  penaltyPercentagePerInstallment: { type: Number, default: 2 }, // % increase per extra installment
  isActive: { type: Boolean, default: true }
}, { timestamps: true });

module.exports = mongoose.model('Service', serviceSchema);